// PageSettingPU.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingPU.h"
#include "Include\CommonFun.h"
#include "Include\CLS_NVDSDK_Interface.h"

// CPageSettingPU dialog

IMPLEMENT_DYNAMIC(CPageSettingPU, CDialog)

CPageSettingPU::CPageSettingPU(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSettingPU::IDD, pParent)
{

}

CPageSettingPU::~CPageSettingPU()
{
}

void CPageSettingPU::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_IPADDRESS_PLATFORMIP, m_IpAddrPlatformIP);
	DDX_Control(pDX, IDC_EDIT_PLATFORMPORT, m_EditRegSvrPort);
	DDX_Control(pDX, IDC_CHECK_PLATFORMSERVER, m_ChkRegSvrEnable);
	DDX_Control(pDX, IDC_EDIT_DEVICEID, m_EditDevID);
	DDX_Control(pDX, IDC_EDITREGISTERNAME, m_EditDevName);
	DDX_Control(pDX, IDC_COMBO_REGISTERCHANNEL, m_CboRegChannelType);
	DDX_Control(pDX, IDC_EDIT_REGISTERCHANNELID, m_EditChannelID);
}


BEGIN_MESSAGE_MAP(CPageSettingPU, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_SETPLATFORM, &CPageSettingPU::OnBnClickedButtonSetplatform)
	ON_BN_CLICKED(IDC_BUTTON_SETDEVICEREGISTER, &CPageSettingPU::OnBnClickedButtonSetdeviceregister)
	ON_BN_CLICKED(IDC_BUTTON_SETCHANNELREGISTER, &CPageSettingPU::OnBnClickedButtonSetchannelregister)
	ON_CBN_SELCHANGE(IDC_COMBO_REGISTERCHANNEL, &CPageSettingPU::OnCbnSelchangeComboRegisterchannel)
END_MESSAGE_MAP()


// CPageSettingPU message handlers

void  CPageSettingPU::LoadSurfaceResource()
{
	SetDlgItemText(IDC_STATIC_PLATFORMSERVER, GetText(IDS_SETTING_REGSVR));
	SetDlgItemText(IDC_STATIC_PLATFORMIP, GetText(IDS_SETTING_REGSVRIP));
	SetDlgItemText(IDC_STATIC_PLATFORMPORT, GetText(IDS_SETTING_REGSVRPORT));
	SetDlgItemText(IDC_CHECK_PLATFORMSERVER, GetText(IDS_SETTING_REGSVRENABLE));
	SetDlgItemText(IDC_BUTTON_SETPLATFORM, GetText(IDS_SETTING_SETREGSVR));

	SetDlgItemText(IDC_STATIC_DEVICEREGISTER, GetText(IDS_SETTING_REGDEV));
	SetDlgItemText(IDC_STATIC_DEVNAME, GetText(IDS_SETTING_DEVID));
	SetDlgItemText(IDC_STATIC_REGISTERNAME, GetText(IDS_SETTING_DEVNAME));
	SetDlgItemText(IDC_BUTTON_SETDEVICEREGISTER, GetText(IDS_SETTING_SETREGDEV));

	SetDlgItemText(IDC_STATIC_CHANNELREGISTER, GetText(IDS_SETTING_REGCHANNEL));
	SetDlgItemText(IDC_STATIC_REGISTERCHANNEL, GetText(IDS_SETTING_CHANNEL));
	SetDlgItemText(IDC_STATIC_REGISTERID, GetText(IDS_SETTING_REGCHANNELID));
	SetDlgItemText(IDC_BUTTON_SETCHANNELREGISTER, GetText(IDS_SETTING_SETREGCHANNEL));
}

int CPageSettingPU::Initialize(TDECPARAM* _pdecParam)
{
	LoadSurfaceResource();
	if (NULL != _pdecParam)
	{
		DecRegServer Regs = {0};
		Regs.iSize = sizeof(DecRegServer);
		int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_REGSERVER, &Regs, Regs.iSize);
		m_IpAddrPlatformIP.SetWindowText((LPCTSTR)Regs.cIP);
		CString szTemp1;
		szTemp1.Format("%d", Regs.iPort);
		m_EditRegSvrPort.SetWindowText(szTemp1);
		m_ChkRegSvrEnable.SetCheck(Regs.iEnable);

		DecPuParam PU = {0};
		PU.iSize = sizeof(DecPuParam);
		iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_PUPARAM, &PU, PU.iSize);
		m_EditDevID.SetWindowText((LPCTSTR)PU.cID);
		m_EditDevName.SetWindowText((LPCTSTR)PU.cUsername);

		m_CboRegChannelType.ResetContent();
		CreateChannelCombo(m_lLogonID, &m_CboRegChannelType);
		UpdateChanRegInfo();
	}
    return 0;
}

void CPageSettingPU::OnBnClickedButtonSetplatform()
{
	// TODO: Add your control notification handler code here
	CString szRegSvrIp = _T("");
	int iRegSvrPort = -1;

	//IPǷж
	BYTE Field0, Field1, Field2, Field3;
	int NonBlank=this->m_IpAddrPlatformIP.GetAddress(Field0,Field1,Field2,Field3);
	if (NonBlank!=4)
	{
		MessageBox(GetText(IDS_MAIN_INVALID_IP), _T(""), MB_OK|MB_TOPMOST);
		return;
	}

	GetDlgItemText(IDC_IPADDRESS_PLATFORMIP, szRegSvrIp);
	//жIPǷϷ
	if (!IsValidIP(szRegSvrIp))
	{
		MessageBox(GetText(IDS_MAIN_INVALID_IP), _T(""), MB_OK|MB_TOPMOST);
		return;
	}

	//ж϶˿ǷЧ
	int iPort = GetDlgItemInt(IDC_EDIT_PLATFORMPORT, NULL, FALSE);
	if (iPort > 65535 || iPort <= 0)
	{
		//˿ںλʾ
		MessageBox(GetText(IDS_MAIN_INVALID_PORT), _T(""), MB_OK|MB_TOPMOST);
		return;
	}

	//
	int iRet = DEC_SetRegServer(m_lLogonID, (LPSTR)(LPCTSTR)szRegSvrIp, iPort, m_ChkRegSvrEnable.GetCheck());
	if (0 == iRet)
	{
		MessageBox(GetText(IDS_SETTING_SETOK), _T(""), MB_OK|MB_TOPMOST);
	}
	else
	{
		//ʧ
		MessageBox("cuowu");

	}
}

void CPageSettingPU::OnBnClickedButtonSetdeviceregister()
{
	// TODO: Add your control notification handler code here
	CString szDevID = _T("");
	CString szDevName = _T("");

	//豸IDǷҪ
	GetDlgItemText(IDC_EDIT_REGISTERID, szDevID);
	if ("" == szDevID || strlen(szDevID) > 20)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA),_T(""),MB_OK|MB_TOPMOST);
		return;
	}

	char cDevID[21] = {0};
	strcpy_s(cDevID, sizeof(cDevID), (LPSTR)(LPCTSTR)szDevID);
	for (unsigned int i = 0; i < strlen(szDevID); i++)
	{
		if (cDevID[i] < '0' || cDevID[i] > '9') //IDֻΪ
		{
			//޸
			MessageBox(GetText(IDS_SETTING_INVALIDPARA),_T(""),MB_OK|MB_TOPMOST);
			return;
		}
	}

	//ж豸ǷҪ
	GetDlgItemText(IDC_EDITREGISTERNAME, szDevName);
	if("" == szDevName || strlen(szDevName) > 32)  //鿴豸ǷΪ
	{
		//޸
		MessageBox(GetText(IDS_SETTING_INVALIDPARA),_T(""),MB_OK|MB_TOPMOST);
		return;
	}

	//
	int iRet = DEC_SetRegDevice(m_lLogonID, (LPSTR)(LPCTSTR)szDevID, (LPSTR)(LPCTSTR)szDevName);
	if (0 == iRet)
	{
		MessageBox(GetText(IDS_SETTING_SETOK),_T(""),MB_OK|MB_TOPMOST);
	}
	else
	{
		//
	}
}

void CPageSettingPU::OnBnClickedButtonSetchannelregister()
{
	CString szChannelID = _T("");

	//жChannelIDǷϷ
	GetDlgItemText(IDC_EDIT_REGISTERCHANNELID, szChannelID);
	if ("" == szChannelID)
	{
		//޸
		MessageBox(GetText(IDS_SETTING_INVALIDPARA),_T(""),MB_OK|MB_TOPMOST);
		return;
	}
	if (strlen(szChannelID) > 32)
	{
		//޸
		MessageBox(GetText(IDS_SETTING_INVALIDPARA),_T(""),MB_OK|MB_TOPMOST);
		return;
	}

	int iChannelIndex = GetComboData(&m_CboRegChannelType);//m_CboRegChannelType.GetItemData(m_CboRegChannelType.GetCurSel());
	int iRet = DEC_SetRegChannel(m_lLogonID, iChannelIndex, (LPSTR)(LPCTSTR)szChannelID);
	if (iRet == 0)
	{
		MessageBox(GetText(IDS_SETTING_SETOK),_T(""),MB_OK|MB_TOPMOST);
	}
}

void CPageSettingPU::OnCbnSelchangeComboRegisterchannel()
{
	UpdateChanRegInfo();
}

BOOL CPageSettingPU::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN && (pMsg->wParam == VK_RETURN||pMsg->wParam == VK_ESCAPE)) 
	{ 
		return true;
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CPageSettingPU::UpdateChanRegInfo()
{
	int iIndex = GetComboData(&m_CboRegChannelType);//m_CboRegChannelType.GetCurSel();
	int iChanIndex = GetComboData(&m_CboRegChannelType);//m_CboRegChannelType.GetItemData(iIndex);

	ChannelRegInfoEx stChannelRegInfo = {0};
	stChannelRegInfo.iBuffsize = sizeof(ChannelRegInfoEx);

	int iRet = DEC_ClientGetDevConfig(m_lLogonID, iChanIndex, 0, CMD_DEC_CFG_CHANNEL_REGINFO_EX, &stChannelRegInfo, sizeof(ChannelRegInfoEx));
	if (ERR_SUCCESS == iRet)
	{
		m_EditChannelID.SetWindowText((LPCTSTR)stChannelRegInfo.cRegChannelPUID);
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR, "[CPageSettingPU::UpdateChanRegInfo] DEC_ClientGetDevConfig Failed! Ret(%d),CMDID(%d)",
			iRet, CMD_DEC_CFG_CHANNEL_REGINFO);
	}
}
